/*
 * This File is one of the examples from Java Object Oriented Programming
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package salesApplication;

import datasource.DataSource;
import datasource.FileDataSource;
import java.util.List;
import products.Item;
import products.WritingImplement;


/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class TestPriceList {
    public static void main(String[] args) {
        DataSource ds = new FileDataSource();
        PriceList demo = ds.retrieveList("Demo");
        List<Item> demoList = demo.getList();
        
        //Print out a list of all the writing implements with a 20% discount.
        //First attempt at writing code
        for (Item p:demoList){
            //remove everything that is not a writing implement
            if (p instanceof WritingImplement){
                //Apply a 20% discount to the price of all the remaining products.
                p.setPrice(p.getPrice()*0.8);
                //Print all the products in the list
                System.out.println(p);
            }
        }
    }
}
